

Debug = true
--[[
	Debug_LIB
	Filename: "Debug_LIB.exc"
	Version: 1.0

	Todo:
		Dump function for exception handling.
		Debug_LIB:ERROR feature.
		Scroll Bar.

	Features:
		  Ability to collect and store debug information and display
		correctly error procedures.
		
		RTrigger Activates USB

	Functions:
		Debug_LIB:Show()
			Shows the Debug Menu screen.
		Debug_LIB:Clear()
			Clears Debug Screen.			
		Debug_LIB:PrintF(text)
			Adds information into Collection Bin.
]]--

Debug_LIB = {
	Build = 0.5,
	Date = "5/18/2008",
	String = { },
	USB = nil

}
Debug_LIB.String = { 
	"Build [" .. Debug_LIB.Date .. "]",
	"",
	"",
}
function Debug_LIB:Show()
	local key = Controls.read()
	
	local DebugTimer = os.clock()
	local DEBUG_OFFSET = table.getn(Debug_LIB.String) - 24
	
	local USBTimer = nil
	while true do
		local CHECK_TIME = os.clock() - DebugTimer

		-------------------------------------------------------------
		--                                                         --
		--                       Key Input                         --
		--                                                         --
		-------------------------------------------------------------
		if (CHECK_TIME >= .1) then 
			key = Controls.read()
			if (key:r()) and (not USBTimer)  then
				if (Debug_LIB.USB) then
					System.usbDiskModeDeactivate()
					Debug_LIB.USB = nil
					USBTimer = 3
				else
					System.usbDiskModeActivate()
					Debug_LIB.USB = 1
					USBTimer = 6
				end
				
			end
			if (key:l()) then
				local tmpOut = io.open("ms0:/debugOut.txt","w+")
				for i,item in ipairs(Debug_LIB.String) do
					tmpOut:write(item.."\n")
				end
				tmpOut:close()
				tmpOut = nil
			end
			if (key:up()) then
				DEBUG_OFFSET = DEBUG_OFFSET - 1
				if (DEBUG_OFFSET < 1) then
					if (table.getn(Debug_LIB.String) > 24) then
						DEBUG_OFFSET = 1
					else
						DEBUG_OFFSET = table.getn(Debug_LIB.String) - 24
					end
				end
			end
			if (key:down()) then
			
				DEBUG_OFFSET = DEBUG_OFFSET + 1
				if (DEBUG_OFFSET > (table.getn(Debug_LIB.String) - 24) ) then
					DEBUG_OFFSET = table.getn(Debug_LIB.String) - 24
				end
		
			end
			if (key:select()) then
				break
			end


			DebugTimer = os.clock()
		end
		if (USBTimer) then
			USBTimer = USBTimer - CHECK_TIME
			if (USBTimer <= 0) then
				USBTimer = nil
			end
		end
		-------------------------------------------------------------
		--                                                         --
		--                     Update Display                      --
		--                                                         --
		-------------------------------------------------------------

		screen:clear(Color.new(0,0,0))
		screen:print(185, 0, "Debug Console", Color.new(255,255,255))
		screen:print(376, 0, "[version " .. Debug_LIB.Build .. "]", Color.new(255,255,255))

		screen:fillRect(0, 27, 480, 210, Color.new(211,211,211))
		screen:fillRect(1, 28, 478, 208, Color.new(0,0,0))

		Debug_LIB.String[2] = "Freespace [".. ( System.getFreeMemory() / 1024 / 1024 ) .. "mb]"
		for i = 0, 24 do
			value = Debug_LIB.String[DEBUG_OFFSET + i]
			if (value ~= "") and (value) then
				if (string.len(value) > 60) then
					screen:print(5, 32 + (i*8), string.sub (value, 0 , 56) .. "...", Color.new(255,255,255))
				else
					screen:print(5, 32 + (i*8), value, Color.new(255,255,255))
				end
			end
		end
		if (Debug_LIB.USB) then
			if (USBTimer) then
				screen:print(0, 240, "USB Disk Mode Activated (" .. math.floor(USBTimer / 1) .. ")", Color.new(255,255,255))
			else
				screen:print(0, 240, "USB Disk Mode Activated", Color.new(255,255,255))
			end
		else
			screen:print(0, 240, "Press [R] for USB Mode...", Color.new(255,255,255))
		end
		screen:print(0, 264, "Press [select] to resume.", Color.new(255,255,255))
		screen:print(200, 264, "Press [L] to save log.", Color.new(255,255,255))
		screen:print(400, 264, "[Glasseye]", Color.new(255,255,255))
		screen.waitVblankStart()
		screen.flip()
	end
end
function Debug_LIB:PrintF(...)
	table.insert(Debug_LIB.String, "") -- self added
	for i,text in ipairs(arg) do
		if not text then 
			Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. "nil"
		elseif type(text) == "boolean" then
			if text then
				Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. "true"
			else
				Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. "false"
			end
		elseif type(text)=="string" or type(text)=="number" then
			for i = 1, string.len(text) do
				char = string.sub(text, i, i)
				if char == "\n" then
					table.insert(Debug_LIB.String, "")
				elseif char == "\009" then
					Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. "   "
				elseif char ~= "\r" then
					if #Debug_LIB.String[table.getn(Debug_LIB.String)]>=60 then
						table.insert(Debug_LIB.String, "") -- self added
					end
					Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. char
				end
			end
		else
			Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. type(text)
		end
		Debug_LIB.String[table.getn(Debug_LIB.String)] = Debug_LIB.String[table.getn(Debug_LIB.String)] .. " "
	end
end
function Debug_LIB:Clear()
	Debug_LIB.String = { 
		"Build [" .. Debug_LIB.Date .. "]",
		"",
		"",
	}
end

function printf(...) 
	if Debug then 
		Debug_LIB:PrintF(...)
		Debug_LIB:Show()
	end
end

--[[ Easy Init v0.1
	By The Underminer
	11 April 2008
]]
oldInit = Wlan.init
function Wlan.init()
	--printf("init called")
	if WAct then return true end
	screen:clear()
	screen:flip()
	screen:clear()
	screen:flip()
	oldInit()
	System.sleep(200)
	sucs,tmp = pcall(Wlan.getIP)
	--printf(sucs)
	--printf(tmp)
	if sucs and tmp then 
		WAct=true
		return true		
	else
		Wlan.term(true)
		Wact=false
		return false
	end
end

oldTerm = Wlan.term
function Wlan.term(force)
	if force or WAct then
		oldTerm()
		WAct = false
	end
end

function loadScript(name)
	local oldPath = System.currentDirectory()
	System.currentDirectory("usbhost0:/PSP/GAME380/texttest/")
	script,err = loadfile(name)
	if not script then printf(err) end
	script()
	script = nil
	System.currentDirectory(oldPath)
	oldPath = nil
end

function bareString(input)
	local output = input:gsub("\r","\R")
	output = output:gsub("\n","\N")
	return output
end


--System.currentDirectory("Applications")
appsDir = System.currentDirectory()

--System.currentDirectory("Special Operations")
dofile("index.lua")